/*
 * Decompiled with CFR 0.152.
 */
package com.obscuria.obscureapi.util;

import com.obscuria.obscureapi.ObscureAPIClient;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipBlockStateContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeMod;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nullable;

public final class EntityUtils {
    public static void playLocalDynamicSound(Entity entity, SoundEvent sound, SoundSource source, float volume, float pitch) {
        if (entity.f_19853_.f_46443_) {
            ObscureAPIClient.playLocalDynamicSound(entity, sound, source, volume, pitch);
        }
    }

    public static void playLocalDynamicSound(Entity entity, SoundEvent sound, SoundSource source, float volume, float pitch, Predicate<Entity> condition, boolean loop) {
        if (entity.f_19853_.f_46443_) {
            ObscureAPIClient.playLocalDynamicSound(entity, sound, source, volume, pitch, condition, loop);
        }
    }

    public static List<LivingEntity> getRelativeEntities(LivingEntity entity, Class<? extends LivingEntity> targets, float forward, float left, float up, float area) {
        return EntityUtils.getRelativeEntities(entity, targets, forward, left, up, area, false, false);
    }

    public static List<LivingEntity> getRelativeEntities(LivingEntity entity, Class<? extends LivingEntity> targets, Vec3 pos, float area) {
        return EntityUtils.getRelativeEntities(entity, targets, pos, area, false, false);
    }

    public static List<LivingEntity> getRelativeEntities(LivingEntity entity, Class<? extends LivingEntity> targets, float forward, float left, float up, float area, boolean visibleOnly) {
        return EntityUtils.getRelativeEntities(entity, targets, forward, left, up, area, visibleOnly, false);
    }

    public static List<LivingEntity> getRelativeEntities(LivingEntity entity, Class<? extends LivingEntity> targets, Vec3 pos, float area, boolean visibleOnly) {
        return EntityUtils.getRelativeEntities(entity, targets, pos, area, visibleOnly, false);
    }

    public static List<LivingEntity> getRelativeEntities(LivingEntity entity, Class<? extends LivingEntity> targets, float forward, float left, float up, float area, boolean visibleOnly, boolean circle) {
        return EntityUtils.getRelativeEntities(entity, targets, EntityUtils.getRelativePos((Entity)entity, forward, left, up), area, visibleOnly, circle);
    }

    public static List<LivingEntity> getRelativeEntities(LivingEntity entity, Class<? extends LivingEntity> targets, Vec3 pos, float area, boolean visibleOnly, boolean circle) {
        List list = entity.f_19853_.m_45976_(targets, new AABB(pos, pos).m_82400_((double)area));
        ArrayList<LivingEntity> entities = new ArrayList<LivingEntity>();
        list.forEach(entry -> {
            if (!(visibleOnly && !entity.m_142582_((Entity)entry) || circle && !(pos.m_82554_(entry.m_20182_()) <= (double)area))) {
                entities.add((LivingEntity)entry);
            }
        });
        return entities;
    }

    public static Vec3 getRelativePos(Entity entity, float forward, float left, float up) {
        Vec2 vec2 = new Vec2(entity.m_5686_(1.0f), entity.m_5675_(1.0f));
        Vec3 vec3 = entity.m_20299_(1.0f);
        float f = Mth.m_14089_((float)((vec2.f_82471_ + 90.0f) * ((float)Math.PI / 180)));
        float f1 = Mth.m_14031_((float)((vec2.f_82471_ + 90.0f) * ((float)Math.PI / 180)));
        float f2 = Mth.m_14089_((float)(-vec2.f_82470_ * ((float)Math.PI / 180)));
        float f3 = Mth.m_14031_((float)(-vec2.f_82470_ * ((float)Math.PI / 180)));
        float f4 = Mth.m_14089_((float)((-vec2.f_82470_ + 90.0f) * ((float)Math.PI / 180)));
        float f5 = Mth.m_14031_((float)((-vec2.f_82470_ + 90.0f) * ((float)Math.PI / 180)));
        Vec3 vec31 = new Vec3((double)(f * f2), (double)f3, (double)(f1 * f2));
        Vec3 vec32 = new Vec3((double)(f * f4), (double)f5, (double)(f1 * f4));
        Vec3 vec33 = vec31.m_82537_(vec32).m_82490_(-1.0);
        double d0 = vec31.f_82479_ * (double)forward + vec32.f_82479_ * (double)up + vec33.f_82479_ * (double)left;
        double d1 = vec31.f_82480_ * (double)forward + vec32.f_82480_ * (double)up + vec33.f_82480_ * (double)left;
        double d2 = vec31.f_82481_ * (double)forward + vec32.f_82481_ * (double)up + vec33.f_82481_ * (double)left;
        return new Vec3(vec3.f_82479_ + d0, vec3.f_82480_ + d1, vec3.f_82481_ + d2);
    }

    public static float getYAngleBetween(Entity first, Entity second) {
        return EntityUtils.getYAngleBetween(first.m_20185_(), first.m_20189_(), second.m_20185_(), second.m_20189_());
    }

    public static float getYAngleBetween(double x1, double z1, double x2, double z2) {
        double result = x2 > x1 ? Math.atan2(x2 - x1, z1 - z2) * 180.0 / Math.PI : (x2 < x1 ? 360.0 - Math.atan2(x1 - x2, z1 - z2) * 180.0 / Math.PI : Math.atan2(0.0, 0.0));
        return (float)(result + 180.0 > 360.0 ? result - 180.0 : result + 180.0);
    }

    public static void setMotion(Entity entity, Vec3 velocity) {
        entity.m_20256_(velocity);
        entity.f_19864_ = true;
    }

    public static void addMotion(Entity entity, Vec3 velocity) {
        EntityUtils.setMotion(entity, entity.m_20184_().m_82549_(velocity));
    }

    public static void setMotion(Entity entity, float x, float y, float z) {
        EntityUtils.setMotion(entity, new Vec3((double)x, (double)y, (double)z));
    }

    public static void setMotionX(Entity entity, float x) {
        entity.m_20334_((double)x, entity.m_20184_().f_82480_, entity.m_20184_().f_82481_);
    }

    public static void setMotionY(Entity entity, float y) {
        entity.m_20334_(entity.m_20184_().f_82479_, (double)y, entity.m_20184_().f_82481_);
    }

    public static void setMotionZ(Entity entity, float z) {
        entity.m_20334_(entity.m_20184_().f_82479_, entity.m_20184_().f_82480_, (double)z);
    }

    public static void addMotion(Entity entity, float x, float y, float z) {
        EntityUtils.addMotion(entity, new Vec3((double)x, (double)y, (double)z));
    }

    public static Projectile shootProjectile(Projectile projectile, Entity entity, float pitch, float yaw, float newPitch, float speed, float spread) {
        Projectile projectileEntity = EntityUtils.shootProjectileIgnoreMotion(projectile, entity, pitch, yaw, newPitch, speed, spread);
        Vec3 vec = entity.m_20184_();
        projectileEntity.m_20256_(projectileEntity.m_20184_().m_82520_(vec.f_82479_, entity.m_20096_() ? 0.0 : vec.f_82480_, vec.f_82481_));
        return projectileEntity;
    }

    @Contract(value="_, _, _, _, _, _, _ -> param1")
    public static Projectile shootProjectileIgnoreMotion(Projectile projectile, Entity entity, float pitch, float yaw, float newPitch, float speed, float spread) {
        float f = (float)(-Math.sin((double)yaw * (Math.PI / 180)) * Math.cos((double)pitch * (Math.PI / 180)));
        float f1 = (float)(-Math.sin((double)(pitch + newPitch) * (Math.PI / 180)));
        float f2 = (float)(Math.cos((double)yaw * (Math.PI / 180)) * Math.cos((double)pitch * (Math.PI / 180)));
        projectile.m_6686_((double)f, (double)f1, (double)f2, speed, spread);
        projectile.m_5602_(entity);
        projectile.m_20256_(projectile.m_20184_());
        return projectile;
    }

    public static BlockHitResult rayTrace(Level level, Entity entity, Predicate<BlockState> predicate, double maxDist) {
        Vec3 eye = entity.m_20299_(1.0f);
        float f2 = (float)Math.cos((double)(-entity.m_6080_()) * (Math.PI / 180) - Math.PI);
        float f3 = (float)Math.sin((double)(-entity.m_6080_()) * (Math.PI / 180) - Math.PI);
        float f4 = (float)(-Math.cos((double)(-entity.m_146909_()) * (Math.PI / 180)));
        float f5 = (float)Math.sin((double)(-entity.m_146909_()) * (Math.PI / 180));
        float f6 = f3 * f4;
        float f7 = f2 * f4;
        Vec3 vector = eye.m_82520_((double)f6 * maxDist, (double)f5 * maxDist, (double)f7 * maxDist);
        return level.m_151353_(new ClipBlockStateContext(eye, vector, predicate));
    }

    public static BlockHitResult rayTrace(Level level, LivingEntity entity, Predicate<BlockState> predicate) {
        double maxDist = entity.m_21133_((Attribute)ForgeMod.REACH_DISTANCE.get());
        return EntityUtils.rayTrace(level, (Entity)entity, predicate, maxDist);
    }

    public static BlockHitResult rayTrace(Level level, Entity entity, double maxDist) {
        return EntityUtils.rayTrace(level, entity, state -> state.m_60767_().m_76333_(), maxDist);
    }

    public static BlockHitResult rayTrace(Level level, LivingEntity entity) {
        double maxDist = entity.m_21133_((Attribute)ForgeMod.REACH_DISTANCE.get());
        return EntityUtils.rayTrace(level, (Entity)entity, maxDist);
    }

    public static BlockHitResult rayTraceFluid(Level level, Entity entity, double maxDist) {
        return EntityUtils.rayTrace(level, entity, state -> state.m_60767_().m_76332_(), maxDist);
    }

    public static BlockHitResult rayTraceFluid(Level level, LivingEntity entity) {
        double maxDist = entity.m_21133_((Attribute)ForgeMod.REACH_DISTANCE.get());
        return EntityUtils.rayTrace(level, (Entity)entity, maxDist);
    }

    @Nullable
    public static Entity rayTraceEntity(Player entity, Class<? extends Entity> target, int distance, Predicate<Entity> predicate) {
        Vec3 pos;
        Vec3 direction = EntityUtils.direction((Entity)entity);
        for (double i = 0.0; i < (double)distance + 0.375 && !entity.f_19853_.m_8055_(new BlockPos(pos = new Vec3(entity.m_20185_() + direction.f_82479_ * i, entity.m_20188_() - 0.2 + direction.f_82480_ * i, entity.m_20189_() + direction.f_82481_ * i))).m_60767_().m_76333_(); i += 0.5) {
            for (Entity targetEntity : entity.f_19853_.m_6443_(target, new AABB(pos.f_82479_ - 0.1, pos.f_82480_ - 0.1, pos.f_82481_ - 0.1, pos.f_82479_ + 0.1, pos.f_82480_ + 0.1, pos.f_82481_ + 0.1), e -> e.m_19879_() != entity.m_19879_())) {
                if (!predicate.test(targetEntity)) continue;
                return targetEntity;
            }
        }
        return null;
    }

    public static Vec3 direction(Entity entity) {
        float rotationYaw = entity.m_6080_();
        float rotationPitch = entity.m_146909_();
        float x = (float)(-Math.sin(Math.toRadians(rotationYaw)) * Math.cos(Math.toRadians(rotationPitch)));
        float y = (float)(-Math.sin(Math.toRadians(rotationPitch)));
        float z = (float)(Math.cos(Math.toRadians(rotationYaw)) * Math.cos(Math.toRadians(rotationPitch)));
        return new Vec3((double)x, (double)y, (double)z);
    }

    public static ItemStack helmet(LivingEntity entity) {
        return entity.m_6844_(EquipmentSlot.HEAD);
    }

    public static ItemStack chestplate(LivingEntity entity) {
        return entity.m_6844_(EquipmentSlot.CHEST);
    }

    public static ItemStack leggings(LivingEntity entity) {
        return entity.m_6844_(EquipmentSlot.LEGS);
    }

    public static ItemStack boots(LivingEntity entity) {
        return entity.m_6844_(EquipmentSlot.FEET);
    }

    public static ItemStack mainHand(LivingEntity entity) {
        return entity.m_6844_(EquipmentSlot.MAINHAND);
    }

    public static ItemStack offhand(LivingEntity entity) {
        return entity.m_6844_(EquipmentSlot.OFFHAND);
    }

    public static boolean canSpawnAtPosition(LevelReader level, BlockPos spawnPos, EntityType<?> type) {
        AABB size = new AABB(spawnPos).m_82377_((double)type.m_20678_(), (double)type.m_20679_(), (double)type.m_20678_());
        return BlockPos.m_121921_((AABB)size).noneMatch(pos -> level.m_8055_(pos).m_60767_().m_76333_() || level.m_6425_(pos).m_205070_(FluidTags.f_13132_));
    }
}

